/**************************************************
*  FILE:  board.h		                          *
*  AUTHOR:  Steven Silvey                         *
*  DATE:  7/15/2006                               *
*                                                 *
*  Maintains the game board area where the toggles*
*  float above.                                   *
**************************************************/

#ifndef _BOARD_H_
#define _BOARD_H_


#include "toggle.h"
#include "water.h"
#include "bonus.h"
#include "progress_bar.h"
#include "option.h"
typedef class PROGRESS_BAR progress_bar;
typedef class TOGGLE toggle;
typedef class WATER water;
typedef class games GAMES;
typedef class BONUS bonus;
//typedef enum BONUSES bonuses;
typedef class OPTION option;

#define MAX_ROWS 40
#define MAX_COLUMNS 40
#define MAX_BONUSES 25
#define CLOCKS_PER_LEVEL 10
#define MAX_SLOTS 6
#define TOGGLE_TYPES 4



class BOARD
{
public:
	bool alive;	
	float fPercentage;
	float fTime;
	int iConsecutive;
	int iHConsecutive;
	int iConsistent, iIncrement;	
	int iCurrent_Time;
	
	bool ultima;
	int ultima_trans;

	int bSlots_X[MAX_SLOTS];
	int bSlots_Y[MAX_SLOTS];


	BOARD();
	~BOARD();
	
	void setup( int W, int H, int Padding);
	void resetup( int Row_Count, float fPercent, int iTime);

	void destroy();
	void destroy_bonuses();
	void reset_bonuses();
	void update();
	void draw();
	void draw_bonuses(BITMAP *bDisplay);
	void draw_type(BITMAP *bDisplay, int index, float r, float g, float b, float fIntensity);
	void draw_buttons(BITMAP *bDisplay);
	void set_progress_max(float fNeeded);
	float progress_max();
	BITMAP *image();
	void generate_bonus(int iDifficulty, int x, int y);
	void clear_bonuses();
	void slide_bonuses();

	bool complete();

	void input();
	void use_bonus();

	void set_difficulty(int iValue);


	int  tile_size();
	void set_timer(int iTime);
	void reset_clock();
	void set_slot(int i, BONUS *bTemp);
	int current_slot();

	void toggle_down( int i, int j);
	int toggle_x(int mx, int my);
	int toggle_y(int mx, int my);

	void combo(int iAdd);

	int bsize();



private:
	
	BITMAP *bType[TOGGLE_TYPES];
	BITMAP *bPiece;
	BITMAP *bStars;

	TOGGLE *tToggles[MAX_ROWS][MAX_COLUMNS];
	int iRow_Count;	

	bool ultima_complete;
	int ultima_size;
	int ultima_timer;
	

	OPTION *oHelp_Button;
	


	
	int iDifficulty;
	
	
	
	int iTimer;
	int iTimer_Offset;
	int input_timer;

	int iSize;
	int iSpace;

	int iWidth, iHeight;
	int iPadding;

	float fPCurrent_Max;
	float fPMax;

	PROGRESS_BAR *pToggle_Progress;
	bool bParticle_Effect;

	BONUS *bGift[MAX_BONUSES];
	BONUS *bSlots[MAX_SLOTS];
	
	void arrange_tiles(int Board_Size, int Padding, int Row_Count);
	void init();
	void board_game_over();
	void setup_clocks(int Row_Count);

	bool input_lock;
	BITMAP *bImage;	

};

#endif /* End of _BOARD_H_ */
