/**************************************************
*  FILE:  config.h		                          *
*  AUTHOR:  Steven Silvey                         *
*  DATE:  8/22/2006                               *
*                                                 *
*  This object acts as a communication method for *
*  handling different config file routines.       *
*  There is a modifiable spot for custom routines *
*  in the load functions that needs to be main-   *
*  tained for each usage of this singleton class. *
**************************************************/

#ifndef _CONFIG_H_
#define _CONFIG_H_

class CONFIG
{
public:
	int MODE;
	int sfx_volume;
	int music_volume;
	int pan, mspeed;
	int w,h,bpp;
	char level[30];
	int clock_speed;
	int framerate;

	int R,G,B;
	int shade, segments;
	int still_background;
	int mouse_icon;
	float mouse_speed;

	int no_water_change;
	int wwidth;
	int wheight;
	int wdamper;
	int wsmooth;
	int wclear_init;
	char *wunder_water;
	char *wwater_surface;

	int allow_online;
	int optimize;
	int opti_limit;

	int debug_level;

	CONFIG();
	~CONFIG();

	void load();
	void write();

	int strcmp_no_case(const char*lhs, const char*rhs);

private:
	void destroy();
	void init();

	void standard_load();
	void customized_load();

	void graphics();
	void audio();
	void timing();
};

#endif /* End of _CONFIG_H_ */
