/**************************************************
*  FILE:  game.h                                  *
*  AUTHOR:  Steven Silvey                         *
*  DATE:  4/29/2006                               *
*                                                 *
*  Used to initialize and oversee general game    *
*  functions.                                     *
**************************************************/

#ifndef _GAME_H_
#define _GAME_H_

//********** GAME VERSION ****************
#define VERSION "2.0.1"
#define fVERSION 1.0

#include "allegro.h"
#include "allegro_color.h"
#include "allegro_input.h"

#include "simple_gui.h"
#include "progress_bar.h"
#include "water.h"
#include "board.h"
#include "particle_engine.h"
#include "lightning.h"
#include "dj.h"
#include "score.h"
#include "penalty.h"
#include "hsc.h"
#include "data.h"
#include "configs.h"
#include "title.h"
#include "message.h"


// ******* Translucent and Lighting Setup
extern PALETTE pal;
extern COLOR_MAP trans_table;
	


// ******** GLOBALS ********



// ******** ENUMS ********
enum GAME_STATE{NO_STATE=0, TITLE_SCREEN, PLAY_GAME, HIGHSCORES, PAUSED};

// ******** INPUT *********
extern INPUT gInput;

// ******* MAPPY ********


// ****** MISC ***********
extern int startpos;
#define CHAR_SIZE 20

#define MAX_MESSAGES 10

// ******** GAME STRUCTURE ***********
class games
{
public:
	int gFade_Timer;
	int gTransparency;

	SIMPLE_GUI *sToggles_Screen;
	WATER *wToggles_Water;
	BITMAP *bWater;
	BITMAP *bMouse;
	int iTemp;

	BOARD *bBoard;	
	PROGRESS_BAR *pTime_Progress;
	PARTICLE_ENGINE *peCombo;
	PARTICLE_ENGINE *peToggle_Stars;
	PARTICLE_ENGINE *peZip_Stars;
	PARTICLE_ENGINE *peFire;	
	LIGHTNING *lLightning;
	
	PENALTY *pPenalty_Screen;
	PENALTIES pCurrent_Penalty;

	DJ audio;

	CONFIG *configuration;
	TITLE *MainMenu;
	GAME_STATE state;

	DATAFILE *dat2;
	DATAFILE *dat3;
	DATAFILE *dat4;
	DATAFILE *mydat;
	FONT *score_font;
	PALETTE *score_palette;
	FONT *help_font;
	PALETTE *help_palette;
	FONT *msg_font;
	PALETTE *msg_palette;
	PALETTE *blue_palette;
	SCORE *gScore;

	BITMAP *bLevel;

	MESSAGE *cMessages[MAX_MESSAGES];

	HSC *gHSC;
	
	char cName[CHAR_SIZE];

	int low_score;
	bool view_online;
	float version;

	int pause_ticks;
	int pause_system;

	int level;
	int iRows_Temp;
	int secs;
	double percent;
	int difficulty;
	bool next_level;

	bool over;
	bool quit;	

	int high_index;	
	int high_pos;	
	int cName_Index;
	int score_case;
	BITMAP *bHigh_Score;
	BITMAP *bTemp;

	float fMX;
	float fMY;

	bool debugger;

	void logo_screen(bool status);
	void play_game();
	void setup();
	void level_init();
	
private:
	
	void init();
	void level_finish();
	void update();
	void draw();
	void shutdown();
	
};





#endif /* End of _GAME_H_ */
