/**************************************************
*  FILE:  hsc.h			                          *
*  AUTHOR:  Steven Silvey                         *
*  DATE:  8/1/2006                                *
*                                                 *
*  This object handles the High Score table, both *
*  local and online.                              *
**************************************************/

#ifndef _HSC_H_
#define _HSC_H_


#include "online.h"
#include "fireworks.h"
typedef class ONLINE online;
typedef class FIREWORK firework;
#define CHAR_SIZE 20
#define MAX_STATS 20
#define MAX_ONLINE_STATS 100
#define MAX_FIREWORKS 100
typedef struct stats
{
	int level;
	int points;
	int version;
	char cversion[10];
	char cName[CHAR_SIZE];
} STATS;

class HSC
{
public:
	HSC();
	~HSC();

	bool local_update();
	void online_submit();
	bool online_check();
	void get_local();
	void get_online();
	int get_online_version();
	void put_online();
	void destroy();
	void draw(BITMAP *bDisplay, int y, int S);
	void draw(BITMAP *bDisplay, int y, int S, int index);
	void draw_online(BITMAP *bDisplay, int y, int S);
	void draw_online(BITMAP *bDisplay, int y, int S, int index);
	void hsc_flip(STATS &s1, STATS &s2);
	void sort();
	void store(char *cData);

	int get_low();
	STATS *get_ostats();
	STATS *get_lstats();
	int online_highscore(int points);
	int local_highscore(int points);
	void draw_highscore(BITMAP *bDisplay);
	

	void update();

private:
	FIREWORK *fWorks[MAX_FIREWORKS];
	
	STATS lStats[MAX_STATS];
	STATS oStats[MAX_ONLINE_STATS];
	ONLINE *oCom;
	bool downloading, get_version, submit_ok;
	int cursor_timer, cursor_flash, cursor_delay;
	int high_timer, fireworks_timer;

	BITMAP *bImage;

	void init();
	void clear();
	void clear_local();
	void clear_online();
	void online_sort();
	void set_online(char *cData);
	long calculateCode(const char *name, int score);
	void highscore();
	void input();
	

};

#endif /* End of _HSC_H_ */
