/**************************************************
*  FILE:  online.h		                          *
*  AUTHOR:  Steven Silvey                         *
*  DATE:  3/04/2007                               *
*                                                 *
**************************************************/

#ifndef _ONLINE_H_
#define _ONLINE_H_


#ifdef ALLEGRO_WINDOWS

#include "winalleg.h"
DWORD WINAPI dwtDownload(LPVOID lParam);
DWORD WINAPI dwtUpload(LPVOID lParam);

#endif

#include <curl/curl.h>

static bool busy;				// In global space so thread can change when done.
size_t get_ohsc(void *ptr, size_t size, size_t nmemb, void *stream);
void errMsg(CURLcode res);
void errMsg(char *cMsg);

	

typedef struct curl_data
{
	CURL *curl;
	CURLcode res;
	char *url;
} cURL_DATA;

class ONLINE
{
public:
	ONLINE();
	~ONLINE();

	bool download(char *url);
	bool os_upload(char *pass_data);
	bool os_download(char *pass_data);
	bool upload(char *url);

	
	bool downloading();
	void complete();
	void err(char *cMsg);
	char *get_dl_buffer();
	void store(char *cData);


private:
#ifdef ALLEGRO_WINDOWS
	HANDLE hThread;
#endif
	bool dlFlag;
	char *dl_buffer;
	char *pass_data;

	void os_close();
	
};



#endif /* End of _ONLINE_H_ */
