/**************************************************
*  FILE:  penalty.h		                          *
*  AUTHOR:  Steven Silvey                         *
*  DATE:  7/30/2006                               *
*                                                 *
**************************************************/

#ifndef _PENALTY_H_
#define  _PENALTY_H_



#define MAX_PENALTIES 6
#define MAX_STATIC 20
enum PENALTIES{NO_PENALTY=0, TIME_DECREASE=1, 
						     ROW_INCREASE=2, 
							 PERCENT_INCREASE=3,
							 TIME_DECREASE_2=4,
							 TIME_DECREASE_4=5,
							 PERCENT_INCREASE_2=6,
							 PERCENT_INCREASE_3=7,
							 ROW_INCREASE_2=8,
							 TIME_INCREASE=9,
							 PERCENT_DECREASE=10,
							 BONUS_PACKAGE=11,
							 MAXED=12,
							 QUESTION=13};

class PENALTY
{
public:
	PENALTY();
	~PENALTY();

	void setup();
	void set_item(int iIndex, int cpath, int X, int Y, int Frames, int Max);
	void set_item(int iIndex, PENALTIES cpath, int Frames, int Max);
	void destroy();
	void update();
	void draw(BITMAP *bDisplay);
	int position();
	void unlock();
	void input(int X, int Y);

	void pic_slots();
	PENALTIES pic_random();

	void choose(int x, int y);

	void move(int x, int y);
	void place(int x, int y);
	

	PENALTIES done();

private:
	BITMAP *bImage;
	BITMAP *bItems[MAX_PENALTIES];
	BITMAP *bStatic[MAX_STATIC];
	int iFrames_X[MAX_PENALTIES];
	int iMax_Frames[MAX_PENALTIES];
	int bItems_X[MAX_PENALTIES];
	int bItems_Y[MAX_PENALTIES];
	int x,y;
	int dx, dy;
	int w,h;

	int istretch_x;
	int istretch_y;
	int iAnimate;

	int iTemp_X;
	int iTemp_Y;
	int iChosen;
	bool lock;
	bool mlock;
	bool alock;

	int update_timer;
	int animate_timer;

	PENALTIES pTemp, pPick;
	PENALTIES pItems[MAX_PENALTIES];


	void init();
	void update_animate(int X, int Y);

};

#endif /* End of _PENALTY_H_ */
