/**************************************************
*  FILE:  progress_bar.h                          *
*  AUTHOR:  Steven Silvey                         *
*  DATE:  7/16/2006                               *
*                                                 *
**************************************************/

#ifndef _PROGRESS_BAR_H_
#define _PROGRESS_BAR_H_



typedef class PROGRESS_BAR
{
public:
	PROGRESS_BAR();
	~PROGRESS_BAR();
	
	void setup(int W, int H, bool SFX, bool bDisplay);
	void resetup(int ifgColor, int ibgColor, float fNeeded);
	void color_change(int ifgColor);

	void setup(int W, int H, int ifgColor, int ibgColor, float fNeeded, bool sfx);
	void destroy();
	void set_progress(float fPercent);
	void set_bar(float fNeeded);
	void draw();
	void update();
	int flash(int iColor1, int iColor2, float percent);

	BITMAP *bDraw();
	bool finished();

private:
	int w, h;

	bool sfx, display_text;

	int bgColor, sbgColor;
	int fgColor, sfgColor;

	int flash_timer;
	int flash_delay;
	float fColor_Intensity;
	bool bFlash;
	bool bFlashing;
	bool bDone;

	int iProgress_X;
	float percent;
	float percent_needed;

	BITMAP *bImage;

	void init();
}PROGRESS_BAR;

#endif /* End of _PROGRESS_BAR_H_*/

