#include "globals.h"
#include "game.h"
#include "bonus.h"

BONUS::BONUS()
{
	init();
}

BONUS::~BONUS()
{
	destroy();
}

void BONUS::reset(BONUSES bType, char *cArray, int X, int Y, int iW, int iH, int Max_Frames, int iSize)
{
	x = X;
	y = Y;
	dx = x;
	dy = y;

	W = iW;
	H = iH;
	Size = iSize;
	iMax_Frames = Max_Frames;
	iFrame_X = 0;

	visible = true;
	type = bType;
	lock = true;
	deadlock = false;

	if(bImage != NULL) 
	{
		destroy_bitmap(bImage);
		bImage = NULL;
	}
	if(bArray != NULL) 
	{
		destroy_bitmap(bArray);
		bArray = NULL;
	}
	
	bImage = create_bitmap_check(W, H);
	bArray = load_bitmap_check(cArray, NULL);	

	if(bType == CLOCK)
		animate_delay = 15;
	else if(bType == BOMB)
		animate_delay = 5;
	else if(bType == BOLT)
		animate_delay = 5;
	else if(bType == BPERCENT)
		animate_delay = 5;
	else if(bType == ULTIMA)
		animate_delay = 5;

}



void BONUS::obtain(int mx, int my)
{
	int i = 0, ix = 0, y_offset = 0;

	if(!visible) return;

	if(mx > x && mx < x + Size
		&& my > y && my < y  + Size)
	{
		
		
		if(deadlock == false && lock == false)
		{
			//place in bonus set
			i = GAME.bBoard->current_slot();
			if(i == -1) return;

			if(type == CLOCK || type == BPERCENT)
				GAME.audio.play_sfx(1);			
			ix = i;
			if(i > 2) 
			{
				ix -= 3;
				y_offset = 60;
			}
			place(GAME.bBoard->bSlots_X[i], GAME.bBoard->bSlots_Y[i]);
			GAME.bBoard->set_slot(i, this);
			GAME.gScore->add(25);
			
			lock = true;
			deadlock = true;

			//particle affect
			GAME.peCombo->explode(50, x + (Size / 2), y + (Size / 2), W, H, 0.8, 0.01, 5.0, 0.03, 10, 0.6);					
			GAME.bBoard->use_bonus();
		}
	}		
	else
		lock = false;
	
}


void BONUS::destroy()
{
	if(bImage != NULL) destroy_bitmap(bImage);
	if(bArray != NULL) destroy_bitmap(bArray);
}

void BONUS::update(int mx, int my)
{
	debug("BONUS update() called!\n", 2);
	if(abs(ticks - animate_timer) > animate_delay)
	{
		iFrame_X++;
		if(iFrame_X >= iMax_Frames) iFrame_X = 0;
		animate_timer = ticks;
	}

	obtain(mx, my);

	if(abs(ticks - move_timer) > 5)
	{
		move();
		move_timer = ticks;
	}

	debug("BONUS update() DONE!\n", 2);
}

void BONUS::draw(BITMAP *bDisplay, int iW, int iH)
{	
	if(deadlock == false)
		masked_stretch_blit(bArray, bDisplay, iFrame_X * W, 0, W, H, x + 20, y + 20, iW, iH);
	else
		masked_stretch_blit(bArray, bDisplay, iFrame_X * W, 0, W, H, x + 20, y + 20, W, H);
}

void BONUS::move()
{
	int mx = 0, my = 0;
	if(x != dx)
		mx = (dx - x) / 5;
	if(y != dy)
		my = (dy - y) / 5;
	if(abs(dx - x) < 2) x = dx;
	if(abs(dy - y) < 2) y = dy;

	x += mx;
	y += my;
}

void BONUS::place(int X, int Y)
{
	dx = X;
	dy = Y;
}

bool BONUS::use()
{
	int iX = 0, iY = 0, iSize = 0;
	if(GAME.fMX < 20 || GAME.fMX > 420 || GAME.fMY < 20 || GAME.fMY > 420)
		return false;
	if(type == CLOCK)
	{			
		GAME.peToggle_Stars->explode(150, 565, 142, 65, 25, 1.0, 0.01, 1.0, 0.05, 60);
		GAME.bBoard->reset_clock();
	}
	else if(type == BOMB)
	{
		GAME.audio.play_sfx(10);		
		iX = GAME.bBoard->toggle_x(GAME.fMX - 20, GAME.fMY - 20);
		iY = GAME.bBoard->toggle_y(GAME.fMX - 20, GAME.fMY - 20);
		GAME.peFire->explode(100, GAME.fMX - 20, GAME.fMY - 20, 50, 50, 1.0, 0.01, 1.0, 0.05, 30, 0.45);
		GAME.bBoard->toggle_down( iX, iY);
		GAME.bBoard->toggle_down( iX - 1, iY);
		GAME.bBoard->toggle_down( iX - 2, iY);		
		GAME.bBoard->toggle_down( iX + 1, iY);
		GAME.bBoard->toggle_down( iX + 2, iY);		
		GAME.bBoard->toggle_down( iX - 1, iY + 1);
		GAME.bBoard->toggle_down( iX, iY + 1);
		GAME.bBoard->toggle_down( iX + 1, iY + 1);				
		GAME.bBoard->toggle_down( iX, iY + 2);				
		GAME.bBoard->toggle_down( iX - 1, iY - 1);		
		GAME.bBoard->toggle_down( iX, iY - 1);
		GAME.bBoard->toggle_down( iX + 1, iY - 1);				
		GAME.bBoard->toggle_down( iX, iY - 2);				
	}
	else if( type == BOLT)
	{
		GAME.audio.play_sfx(5);		
		iX = GAME.bBoard->toggle_x(GAME.fMX - 20, GAME.fMY - 20);
		iY = GAME.bBoard->toggle_y(GAME.fMX - 20, GAME.fMY - 20);
		for(int j = 0; j < 30; j++)
			GAME.bBoard->toggle_down( iX, j);
		for(int k = 0; k < 30; k++)
			GAME.bBoard->toggle_down( k, iY);

		iX = GAME.fMX;
		iY = GAME.fMY;
		iSize = GAME.bBoard->tile_size();
		
		GAME.lLightning->setup(iX, iY, iX - iSize / 2, iX + iSize / 2, iY - iSize / 2, iY + iSize / 2);
	}
	else if(type == BPERCENT)
	{
		GAME.bBoard->set_progress_max(GAME.bBoard->progress_max() * 0.75);
	}
	else if(type == ULTIMA)
	{
		GAME.audio.play_sfx(9);		
		GAME.bBoard->ultima = true;
		
	}
	
	
	return true;
}

BONUSES BONUS::get_type()
{
	return type;
}

void BONUS::init()
{
	W = 0;
	H = 0;
	x = 0;
	y = 0; 	
	dx = 0;
	dy = 0;
	bImage = NULL;
	bArray = NULL;
	iFrame_X = 0;
	iMax_Frames = 0;
	animate_timer = 0;
	animate_delay = 0;
	move_timer = 0;
	Size = 0;
	
	type = NONE;
	visible = false;
	lock = false;
	deadlock = false;
}
