#include "globals.h"
#include "game.h"
#include "allegro.h"
#include "alogg.h"
#include "dj.h"
#include "list.h"
#include<string.h>
#include <alogg/alogg.h>

DJ::DJ()
{
    playlist = NULL;
	lSong = NULL;
	iMax_Songs = 0;
	repeat = false;
	power = false;
	fOgg = NULL;
	current = NULL;
	len = 0;
	shuffler = false;
	data = NULL;
	volume = 0;
	sfx_volume = 0;
	pan = 0;
	speed = 0;
	music_timer = 0;
	loop = false;

	for(int i = 0; i < MAX_SAMPLES; i++)
		sfx[i] = NULL;
}

DJ::~DJ()
{

}

void DJ::setup()
{	
	setup(64, 255, 127, 1000);
}

void DJ::setup(int V, int SV, int P, int S)
{
	iMax_Songs = 0;
	volume = V;
	pan = P;
	speed = S;
	sfx_volume = SV;
}
void DJ::breakdown()
{
	if(data != NULL) delete data;
	if(current != NULL) destroy_sample(current);
	if(fOgg != NULL) fclose(fOgg);
	if(playlist != NULL) Destroy_List(playlist);	

	// Just for extra paranoia safety...  :)
	data = NULL;
	current = NULL;
	fOgg = NULL;

	/*for(int i = 0; i < MAX_SAMPLES; i++)
		if(sfx[i] != NULL)
		{
			//destroy_sample(sfx[i]);
			sfx[i] = NULL;
		}*/
}

void DJ::load_sfx(int index, char *cpath)
{
	if(index < 0 || index >= MAX_SAMPLES || sfx[index] != NULL)
		return;
	
	sfx[index] = load_sample(cpath);
}

void DJ::load_sfx(int index, int iOffset)
{
	if(index < 0 || index >= MAX_SAMPLES || sfx[index] != NULL)
		return;
		
	sfx[index] = (SAMPLE *) GAME.dat2[iOffset].dat;
}


void DJ::play_sfx(int index)
{
	if(index < 0 || index >= MAX_SAMPLES || sfx[index] == NULL)
		return;
	
	play_sample(sfx[index], sfx_volume, 128, 1000, false);
}

void DJ::play_sfx(int index, int freq)
{
	if(index < 0 || index >= MAX_SAMPLES || sfx[index] == NULL)
		return;
	
	if(freq > 3000) freq = 3000;
	if(freq < 1000) freq = 1000;
	play_sample(sfx[index], sfx_volume, 128, freq, false);
}

void DJ::add_to_playlist(char *cSong)
{
	add_to_playlist(cSong, 1);
}

void DJ::set_loop()
{
	loop = true;
}

void DJ::update()
{
	update(0);
}

void DJ::update(int i)
{
	int iCurrentz = 0;
	debug("DJ update() called!\n", 2);
	if(current == NULL)
	{
		lSong = playlist;
		while(iCurrentz != i && lSong->next != NULL)
		{
			lSong = lSong->next;			
			if(lSong == NULL) 
			{
				if(shuffler)
					shuffle();
				lSong = playlist;
				
			}
			iCurrentz++;
		}
		
		play(lSong->ckey);
	}
/*	else
	{		
		if(!alogg_is_playing_ogg(current))
		{
			//NOTE:  This is where we pick the next song...shuffler should come into affect here!!!
			//move to next song in list
			while(iCurrentz != i && lSong->next != NULL)
			{
				lSong = lSong->next;			
				if(lSong == NULL) 
				{
					if(shuffler)
						shuffle();
					lSong = playlist;
					
				}
				iCurrentz++;
			}
			play(lSong->ckey);
		}
	}*/

	debug("DJ update() DONE!\n", 3);
}

void DJ::add_to_playlist(char *cSong, int iNumber)
{
	LIST *lTemp, *traverse;
	int iID;

	lTemp = Create_List();
	strcpy(lTemp->ckey, cSong);
	iMax_Songs++;

	// Give this song an ID number
	traverse = playlist;
	iID = iNumber;
	while(traverse != NULL)
	{
		if(iID == traverse->ikey)
		{
			iID++;
			traverse = playlist;
		}
		traverse = traverse->next;
	}

	lTemp->ikey = iID;

	playlist = Add_List(playlist, lTemp);

}


void DJ::shuffle_on()
{
	shuffler = true;
	shuffle();
}

void DJ::shuffle()
{
	int iMove, iCount;
	LIST *lTemp = NULL, *traverse;
	bool need_to_move = true;

	while(need_to_move)
	{
		iMove = rand() % iMax_Songs;
		traverse = playlist;
		need_to_move = false;
		iCount = 0;
		while(traverse != NULL && iCount < iMax_Songs)
		{
			if(iCount == iMove && traverse->ikey != -1)
			{				
				lTemp = Add_List(lTemp, traverse);
				traverse->ikey = -1;
			}

			if(traverse->ikey != -1)
				need_to_move = true;

			traverse = traverse->next;
			iCount++;
		}
	}
	Destroy_List(playlist);
	playlist = lTemp;	
}

void DJ::play()
{

}

void DJ::play(char *cSong)
{
	//NOTE:  Don't forget you need to search the playlist as well!!!!!!!!!!


	if(playlist == NULL)
		solo(cSong);
	else
	{
		//volume = 255;
		//play the selected song from the playlist
		if(data != NULL) delete data;		
		if(fOgg != NULL) fclose(fOgg);		
		fOgg = fopen(cSong, "r");		
		if(!fOgg) 
		{
			//Display an error message
			return;
		}
		if(current != NULL) destroy_sample(current);
		len = (int)file_size(cSong);
		data = new char[len];
		
		fread(data, 1, len, fOgg);
		current = alogg_load_ogg(cSong);//(data, len);
		if(current == NULL)
		{
			//Display an error message
			return;
		}

                if(loop == false)
			play_sample(current,volume,pan,speed,0);//alogg_play_ex_ogg(current, 65536, volume, pan, speed, 0);
                else
                        play_sample(current,volume,pan,speed,1);//alogg_play_ex_ogg(current, 65536, volume, pan, speed, 1);

	}

}

void DJ::play(int iNumber)
{
	LIST *traverse;

	if(current == NULL)// || !alogg_is_playing_ogg(current))
	{
		traverse = playlist;
		while(traverse != NULL && traverse->ikey != iNumber)
			traverse = traverse->next;

		if(traverse == NULL) return;
		else play(traverse->ckey);
	}
		
}

bool DJ::fade_out(int iTime)
{
	bool ret_val = false;
	if(volume < 0) return true;
	if(abs(system_time - music_timer) > iTime)
	{
		volume -= 8;
		if(volume < 0) 
		{
			volume = 0;
			ret_val = true;
//			if(alogg_is_playing_ogg(current)) stop();
		}
        adjust_sample(current,volume,pan,speed,0);//alogg_adjust_ogg(current, volume, pan, speed, 0);

		music_timer = system_time;
	}
	
	return ret_val;
}

void DJ::adjust_volume(int v)
{
	volume = v;
	//alogg_adjust_ogg(current, volume, pan, speed, 0);
}

void DJ::adjust_sfx_volume(int v)
{
	sfx_volume = v;
//	alogg_adjust_ogg(current, volume, pan, speed, 0);
}


void DJ::stop()
{
	if(current != NULL) 
                stop_sample(current);//alogg_stop_ogg(current);

	current = NULL;
	//volume = 255;
}

void DJ::solo(char *cSong)
{
	len = (int)file_size(cSong);
	data = new char[len];
    fOgg = fopen(cSong, "r");

	if(!fOgg) 
	{
		//Display an error message
		return;
	}
    
	fread(data, 1, len, fOgg);
	current = alogg_load_ogg(cSong); //alogg_create_ogg_from_buffer(data, len);
	if(current == NULL)
	{
		//Display an error message
		return;
	}

        play_sample(current, volume,pan,speed,1);//alogg_play_ex_ogg(current, 65536, 255, 127, 1000, 1);

	
}
