#include "globals.h"
#include "game.h"
#include "fireworks.h"

FIREWORK::FIREWORK()
{
	init();
}

FIREWORK::~FIREWORK()
{

}


void FIREWORK::update()
{
	debug("FIREWORK update() called!\n", 2);
	if(abs(ticks - update_timer) > 1)
	{
		if(life > 0)
		{
			update_timer = ticks;
			y -= yspeed;
			yspeed -= 0.5;
			life--;
			if(life == 0)
			{
				GAME.audio.play_sfx(10, 1000 + rand() % 350 - rand() % 350);
				GAME.peCombo->explode(35, x, y, 100, 100, 0.5, 0.48, 4.0, 0.08, 30);
				flash_life = 50;
			}
		}
		if(flash_life > 0)
			flash_life--;
	}
	debug("FIREWORK update() DONE!\n", 3);
}

void FIREWORK::draw(BITMAP *bDisplay)
{
	if(life > 0)
	{
		for(int i = 0; i < 5; i++)
			circlefill(bDisplay, x, y + (yspeed * i), 5 - i, col);
	}
	
}

void FIREWORK::draw_flash(BITMAP *bDisplay)
{
	if(flash_life > 0)
	{
		set_trans_blender(getr(col), getg(col), getb(col), 0);
		draw_lit_sprite(bDisplay, bDisplay, 0, 0, flash_life * 2);
	}
}

bool FIREWORK::dead()
{
	if(life <= 0 && flash_life <= 0) 
		return true;
	return false;
}

void FIREWORK::kill()
{
	life = 0;
	flash_life = 0;
}

void FIREWORK::create()
{
	update_timer = 0;
	x = rand() % GAME.configuration->w;
	y = GAME.configuration->h - rand() % 100;
	yspeed = rand() % 10 + 10;
	life = rand() % 25 + 25;
	flash_life = 0;
	col = makecol(rand() % 155 + 100, rand() % 155 + 100, rand() % 155 + 100);
}

void FIREWORK::init()
{
	update_timer = 0;
	x = 0;
	y = 0;
	yspeed = 0;
	life = 0;
	flash_life = 0;
	col = 0;
}

