#include "globals.h"
#include "game.h"
#include <math.h>
#include <stdio.h>

volatile int system_time;
volatile int ticks;
volatile int framerate;
volatile int draw_ticks;
PALETTE pal;
COLOR_MAP trans_table;
BITMAP *buffer;
int gFade_Timer;
int gTransparency;
int startpos;
int iTimer_Speed;
INPUT gInput;
bool iFrameRate;

games GAME;

FILE *flog;

/***********************************************************************************************

										GLOBAL FUNCTIONS

***********************************************************************************************/
//The following functions are defined in the global space for ease of usage.

void timer1(void)
{
	system_time++;			
}END_OF_FUNCTION(timer1);

void frametimer(void)
{
	framerate = draw_ticks;
	draw_ticks = 0;
}END_OF_FUNCTION(frametimer);



int seconds(int iTime){		return iTime * iTimer_Speed;}
bool dTime(int iTime){		return ticks % iTime == 0;}

// This simple function handles all your allegro setup needs.  Remember,
// there has to be a config.ini to set up the game within your directory.
void init()
{
	flog = fopen("log", "w");
	if(!flog)
	{
		printf("Log file could not be opened!");
		exit(0);
	}

	//  Allegro Library
	if(allegro_init() != 0)
	{
		allegro_message("ERROR:  Failed to initialize allegro library.  Terminating program.\n");
		allegro_message("REPORT:  %s\n", allegro_error);
		exit(0);
	}	

	//  Initial Config file stuff...
	GAME.configuration = new CONFIG;
	GAME.configuration->load();
	debug("Allegro init ok!\n", 0);
	
	set_color_depth(GAME.configuration->bpp) ; // 24 bit colour	
	if (set_gfx_mode(GAME.configuration->MODE, GAME.configuration->w, GAME.configuration->h, 0, 0)<0)
	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("ERROR:  Failure to init video mode!  Terminating program.\n");
		allegro_message("REPORT:  %s\n", allegro_error);
		exit(0);
	}
	debug("Graphics mode set!\n", 0);

	set_window_title(" Toggles");
	set_display_switch_mode(SWITCH_BACKGROUND);

	//  Install Timer
	if(install_timer() != 0)
	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("ERROR:  Failed to install timer.  Terminating program.\n");
		allegro_message("REPORT:  %s\n", allegro_error);
		exit(0);
	}
	debug("Timer installed!\n", 0);
	


	//  Install Keyboard	
	if(install_keyboard() != 0)
	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("ERROR:  Failed to install keyboard.  Terminating program.\n");
		allegro_message("REPORT:  %s\n", allegro_error);
		exit(0);
	}	
	debug("Keyboard installed!\n", 0);
	//  Install Mouse
	if(install_mouse() < 0)
	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("ERROR:  Failed to install mouse.  Terminating program.\n");
		allegro_message("REPORT:  %s\n", allegro_error);
		exit(0);
	}	
	debug("Mouse installed!\n", 0);
	
	reserve_voices(32,-1); ///Reserves more channels of sound for us
	
	//  Install Sound
	if(install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL) != 0)	
	{
		allegro_message("ERROR:  Failure to install sound.  Attempting to run without sound.\n");
		allegro_message("REPORT:  %s\n", allegro_error);
		if(install_sound(DIGI_NONE, MIDI_NONE, NULL) != 0)
		{
			allegro_message("ERROR:  Failed to install sound.  Terminating program.\n");
			allegro_message("REPORT:  %s\n", allegro_error);
			exit(0);
		}		
	}
	debug("Sound installed!\n", 0);
		
	srand( (unsigned) time(NULL));
	
	// Install Time Handler
	LOCK_VARIABLE(system_time);
	LOCK_VARIABLE(ticks);
	LOCK_VARIABLE(framerate);
	LOCK_VARIABLE(draw_ticks);
	LOCK_FUNCTION(timer1);
	LOCK_FUNCTION(frametimer);
	iTimer_Speed = GAME.configuration->clock_speed;
	if(iTimer_Speed < 60) iTimer_Speed = 60;
	install_int_ex(timer1, BPS_TO_TIMER(iTimer_Speed));
	install_int_ex(frametimer, BPS_TO_TIMER(1));
	//install_int(timer1, 1000);
	debug("Timer routines locked and ready!\n", 0);
	
	// Setup the buffer
	buffer = create_bitmap(GAME.configuration->w, GAME.configuration->h);
	debug("Created buffer!\n", 0);

	// Setup translucent table
	//create_light_table(&trans_table, pal, 128, 128, 128, NULL);	
	//color_map = &trans_table;
	set_trans_blender(0, 0, 0, 78);
	gFade_Timer = ticks;
	gTransparency = 0;

	// Map the keyboard and joystick
	gInput.map(CANCEL, 0, KEY_ESC, 0);
	gInput.map(LEFT, 0, KEY_LEFT, 0);
	gInput.map(RIGHT, 0, KEY_RIGHT, 0);
	gInput.map(DOWN, 0, KEY_DOWN, 0);
	gInput.map(UP, 0, KEY_UP, 0);
	gInput.map(ACCEPT, 0, KEY_SPACE, 0);
	gInput.map(ACTION_1, 0, KEY_LCONTROL, 0);	
	debug("Mapped keyboard!\n", 0);

	GAME.dat3 = load_datafile("./data/images/m.dat");
	if(!GAME.dat3)
	{
		allegro_message("ERROR:  Couldn't open dat3.dat file.");
		exit(0);
	}
    	
}

void shutdown()
{
	debug("Program shutting down!\n", 0);
	fclose(flog);
}

// Does the same thing as load_bitmap, just has an error message if it can't 
// allocate the memory
BITMAP *load_bitmap_check(char *cpath, RGB *pal)
{
	BITMAP *bTest;
	bTest = load_bitmap(cpath, pal);
	if(!bTest)
	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		
		allegro_message("ERROR:  Could not find/open '%s'", cpath);
		exit(0);
	}
	debug("Loaded bitmap:  ");
	debug(cpath);
	debug("!\n");
	
	return bTest;
}

// Same priniciple as the load_bitmap_check
BITMAP *create_bitmap_check(int width, int height)
{
	BITMAP *bTest;
	bTest = create_bitmap(width, height);
	if(!bTest)
	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("ERROR:  Could not create bitmap.  Memory error.");
		exit(0);
	}
	debug("Created bitmap!\n");
	
	
	return bTest;
}

BITMAP *create_sub_bitmap_check(BITMAP *bParent, int x, int y, int width, int height)
{
	BITMAP *bTest;
	bTest = create_sub_bitmap(bParent, x,y, width, height);
	if(!bTest)
	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("ERROR:  Could not create bitmap.  Memory error.");
		exit(0);
	}
	debug("Created sub bitmap!\n");	

	return bTest;
}

void destroy_bitmap_check(BITMAP *b)
{
	if(b != NULL) {destroy_bitmap(b); b = NULL;}
}

// Deprecated, don't use!
bool screen_fade_in(int iTime)
{
	bool ret_val = false;
	BITMAP *bTransfer;

	if(GAME.gTransparency >= 255) return true;

	if(abs(ticks - GAME.gFade_Timer) > iTime)
	{
		GAME.gTransparency += 8;
		if(GAME.gTransparency > 255) 
		{
			GAME.gTransparency = 255;
			ret_val = true;
		}

		GAME.gFade_Timer = ticks;
	}
	
	bTransfer = create_bitmap_check(buffer->w, buffer->h);
	clear(bTransfer);
	set_trans_blender(0, 0, 0, GAME.gTransparency);	
	draw_trans_sprite(bTransfer, buffer, 0, 0);
	draw_sprite(screen, bTransfer, 0, 0);

	destroy_bitmap(bTransfer);

	return ret_val;
}

// Deprecated, don't use!
bool screen_fade_out(int iTime)
{
	BITMAP *bTransfer;
	bool ret_val = false;	

	if(GAME.gTransparency <= 0) return true;

	if(abs(ticks - GAME.gFade_Timer) > iTime)
	{
		GAME.gTransparency -= 8;
		if(GAME.gTransparency < 0) 
		{
			GAME.gTransparency = 0;
			ret_val = true;
		}

		GAME.gFade_Timer = ticks;
	}

	bTransfer = create_bitmap_check(buffer->w, buffer->h);
	clear(bTransfer);
	set_trans_blender(0, 0, 0, GAME.gTransparency);	
	draw_trans_sprite(bTransfer, buffer, 0, 0);
	draw_sprite(screen, bTransfer, 0, 0);

	destroy_bitmap(bTransfer);

	return ret_val;
}

int distance_squared(int x1, int y1, int x2, int y2)
{
	return pow(x2-x1,2)+pow(y2-y1,2);
}

void rrect(BITMAP *bDisplay, int x1, int y1, int x2, int y2, int r, int col)
{
	int p1 = x1+r, p2 = x2-r, p3 = y1+r, p4 = y2-r;
	
	line(bDisplay, p1, y1, p2, y1, col);
	line(bDisplay, x1, p3, x1, p4, col);
	line(bDisplay, p1, y2, p2, y2, col);
	line(bDisplay, x2, p3, x2, p4, col);
	arc(bDisplay, p1,p3, itofix(64), itofix(128), r, col);
	arc(bDisplay, p2,p3, itofix(0), itofix(64), r, col);
	arc(bDisplay, p1,p4, itofix(128), itofix(192), r, col);
	arc(bDisplay, p2,p4, itofix(192), itofix(0), r, col);
}

void rrectfill(BITMAP *bDisplay, int x1, int y1, int x2, int y2, int r, int col)
{
	rrect(bDisplay, x1, y1, x2, y2, r, col);
	floodfill(bDisplay, (x1+x2)*0.5, (y1+y2)*0.5, col);

}

void create_message(char *s)
{
	int m = 0;
	while(m < MAX_MESSAGES && GAME.cMessages[m] != NULL)
		m++;
	if(m >= MAX_MESSAGES) return;

	GAME.cMessages[m] = new MESSAGE(s, 60, GAME.fMX, GAME.fMY);
}

void debug(char *msg)
{
	debug(msg, 5);
}

void debug(char *msg, int level)
{
	if(level > GAME.configuration->debug_level)
		return;
	fprintf(flog, "%s", msg);
}

