#include "globals.h"
#include "game.h"
#include "online.h"
#include <string.h>

#ifdef ALLEGRO_WINDOWS
#include "winalleg.h"
#endif

#include <curl/curl.h>


#ifdef ALLEGRO_WINDOWS
/********************************************************************************************/
/*                                           OS SPECIFIC                                    */
/********************************************************************************************/
DWORD WINAPI dwtDownload(LPVOID lParam)
{
	CURL *curl;
	CURLcode res;
	
	char *cData = (char *) lParam;
	curl = curl_easy_init();
	if(curl)
	{
		curl_easy_setopt(curl, CURLOPT_URL, cData);	
		curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, get_ohsc);
		curl_easy_setopt(curl, CURLOPT_TIMEOUT, 30);
		res = curl_easy_perform(curl);		
		curl_easy_cleanup(curl);
		if(res != CURLE_OK) 
			errMsg(res);		
		//delete cData;		
	}
	
	busy = false;

	return 0;
}

DWORD WINAPI dwtUpload(LPVOID lParam)
{
	CURL *curl;
	CURLcode res;
	
	char *cData = (char *) lParam;
	curl = curl_easy_init();
	if(curl)
	{			
		curl_easy_setopt(curl, CURLOPT_URL, cData);
		curl_easy_setopt(curl, CURLOPT_TIMEOUT, 30);
		res = curl_easy_perform(curl);		
		curl_easy_cleanup(curl);
		if(res != CURLE_OK) 
			errMsg(res);		
		//delete cData;		
	}
	
	busy = false;

	return 0;
}

bool ONLINE::os_download(char *pass_data)
{
	bool retval = true;
	hThread = CreateThread(NULL, 0, dwtDownload, pass_data, 0, NULL);
	if(hThread == NULL)
	{
		retval = false;
		busy = false;			
		errMsg("Could not create thread!");
		ExitProcess(0);
	}
	return retval;
}

bool ONLINE::os_upload(char *pass_data)
{
	bool retval = true;
	hThread = CreateThread(NULL, 0, dwtUpload, pass_data, 0, NULL);
	if(hThread == NULL)
	{
		retval = false;
		busy = false;
		errMsg("Could not create thread!");
		ExitProcess(0);
	}
	return retval;
}

void ONLINE::os_close()
{
	CloseHandle(hThread);
}

#else
void ONLINE::os_close()
{

}

bool ONLINE::os_download(char *cData)
{
	CURL *curl;
	CURLcode res;
	
	curl = curl_easy_init();
	if(curl)
	{
		curl_easy_setopt(curl, CURLOPT_URL, cData);	
		curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, get_ohsc);
		curl_easy_setopt(curl, CURLOPT_TIMEOUT, 30);
		res = curl_easy_perform(curl);		
		curl_easy_cleanup(curl);
		if(res != CURLE_OK) 
			errMsg(res);		
	}
	
	busy = false;

	return 0;
}

bool ONLINE::os_upload(char *cData)
{
	CURL *curl;
	CURLcode res;
	
	curl = curl_easy_init();
	if(curl)
	{			
		curl_easy_setopt(curl, CURLOPT_URL, cData);
		curl_easy_setopt(curl, CURLOPT_TIMEOUT, 30);
		res = curl_easy_perform(curl);		
		curl_easy_cleanup(curl);
		if(res != CURLE_OK) 
			errMsg(res);		
	}
	
	busy = false;

	return 0;
}
#endif
/*******************************************************************************************/



ONLINE::ONLINE()
{
	busy = false;
	dlFlag = false;
	dl_buffer = NULL;
	pass_data = NULL;
}

ONLINE::~ONLINE()
{
	int c = 0;
	while(busy && c < 100)
	{
		c++;
		rest(5);
	}

	if(busy)
		os_close();
	
	delete pass_data;
}


size_t get_ohsc(void *ptr, size_t size, size_t nmemb, void *stream)
{
	GAME.gHSC->store((char *) ptr);
	return size * nmemb;
}


char *ONLINE::get_dl_buffer()
{
	if(dl_buffer == NULL)
		return NULL;

	return dl_buffer;
}

void ONLINE::store(char *cData)
{
	dl_buffer = new char[strlen(cData) + 1];
	strcpy(dl_buffer, cData);

	// Give the thread a moment to store the data
	rest(100);
}

bool ONLINE::downloading(){	return busy;}
void ONLINE::complete()
{ 
	
	os_close();
	dlFlag = false;
	delete dl_buffer;
	dl_buffer = NULL;
	delete pass_data;
}

bool ONLINE::download(char *url)
{
	bool retval = true;
	
	if(!GAME.configuration->allow_online)
		return false;
	pass_data = new char[strlen(url) + 1];
	strcpy(pass_data, url);

	if(!busy)
	{
		busy = true;		
		retval = os_download(pass_data);				
	}	
	
	return retval;	
}

bool ONLINE::upload(char *url)
{
	bool retval = true;
	
	if(!GAME.configuration->allow_online)
		return false;
	pass_data = new char[strlen(url) + 1];
	strcpy(pass_data, url);

	if(!busy)
	{
		busy = true;
		retval = os_upload(pass_data);		
	}
	
	return retval;	
}


void ONLINE::err(char *cMsg)
{
	errMsg(cMsg);
}

void errMsg(CURLcode res)
{
	FILE *fp;

	fp = fopen("errlog", "a");
	if(fp)
	{
		fprintf(fp, "ERROR:  curl_easy_perform failed.  errcode = %d\n", res);
		fclose(fp);
	}	
}

void errMsg(char *cMsg)
{
	FILE *fp;

	fp = fopen("errlog", "a");
	if(fp)
	{
		fprintf(fp, "ERROR:  %s\n", cMsg);
		fclose(fp);
	}	
}
