#include "globals.h"
#include "game.h"
#include "penalty.h"
#include "data4.h"
#include <string.h>

PENALTY::PENALTY()
{
	init();
}

PENALTY::~PENALTY()
{
	destroy();
}

void PENALTY::setup()
{
	//bImage = load_bitmap_check("./data/images/slot_wheel.pcx", NULL);
	bImage = (BITMAP *) GAME.dat4[SLOT_WHEEL_PCX].dat;
	set_palette((RGB *) GAME.msg_palette);
	textprintf_centre_ex(bImage, GAME.msg_font, bImage->w / 2, bImage->h / 2 - 80, -1, -1, "Level");
	textprintf_centre_ex(bImage, GAME.msg_font, bImage->w / 2, bImage->h / 2 - 40, -1, -1, "Complete!");

	set_palette((RGB *) GAME.blue_palette);
	textprintf_centre_ex(bImage, GAME.score_font, bImage->w / 2, bImage->h / 2 + 20, -1, -1, "Choose one of");
	textprintf_centre_ex(bImage, GAME.score_font, bImage->w / 2, bImage->h / 2 + 40, -1, -1, "the six options...");
	

	
	w = bImage->w;
	h = bImage->h;
	pTemp = NO_PENALTY;

	bStatic[TIME_INCREASE] = load_bitmap_check("./data/images/time_inc.pcx", NULL);
	bStatic[TIME_DECREASE] = load_bitmap_check("./data/images/time_dec.pcx", NULL);
	bStatic[TIME_DECREASE_2] = load_bitmap_check("./data/images/time_dec_2.pcx", NULL);
	bStatic[TIME_DECREASE_4] = load_bitmap_check("./data/images/time_dec_4.pcx", NULL);
	bStatic[PERCENT_DECREASE] = load_bitmap_check("./data/images/percent_dec.pcx", NULL);
	bStatic[PERCENT_INCREASE] = load_bitmap_check("./data/images/percent_inc.pcx", NULL);
	bStatic[PERCENT_INCREASE_2] = load_bitmap_check("./data/images/percent_inc_2.pcx", NULL);
	bStatic[PERCENT_INCREASE_3] = load_bitmap_check("./data/images/percent_inc_3.pcx", NULL);
	bStatic[ROW_INCREASE] = load_bitmap_check("./data/images/row_inc.pcx", NULL);
	bStatic[ROW_INCREASE_2] = load_bitmap_check("./data/images/row_inc_2.pcx", NULL);
	bStatic[BONUS_PACKAGE] = load_bitmap_check("./data/images/bonus_package.pcx", NULL);			
	bStatic[QUESTION] = load_bitmap_check("./data/images/question.pcx", NULL);			
	bStatic[NO_PENALTY] = load_bitmap_check("./data/images/maxed.pcx", NULL);			
	bStatic[MAXED] = load_bitmap_check("./data/images/maxed.pcx", NULL);			

	set_item(0, QUESTION, 109, 38, 0, 8);
	set_item(1, QUESTION, 243, 37, 0, 8);
	set_item(2, QUESTION, 347, 169, 0, 8);
	
}


void PENALTY::set_item(int iIndex, int cpath, int X, int Y, int Frames, int Max)
{
	
	bItems[iIndex] = bStatic[cpath];
	bItems_X[iIndex] = X;
	bItems_Y[iIndex] = Y;
	iFrames_X[iIndex] = Frames;
	iMax_Frames[iIndex] = Max;

}

void PENALTY::set_item(int iIndex, PENALTIES cpath, int Frames, int Max)
{
	bItems[iIndex] = bStatic[cpath];	
	iFrames_X[iIndex] = Frames;
	iMax_Frames[iIndex] = Max;
}



void PENALTY::destroy()
{	
	for(int i = 0; i < MAX_PENALTIES; i++)
		if(bItems[i] != NULL) destroy_bitmap(bItems[i]);
	for(int s = 0; s < MAX_PENALTIES; s++)
		if(bStatic[s] != NULL) destroy_bitmap(bStatic[s]);	
}

void PENALTY::update()
{
	debug("PENALTY update() called!\n", 2);
	//poll_mouse();
	input(GAME.fMX, GAME.fMY);
	if(abs(ticks - update_timer) > 1)
	{
		update_timer = ticks;

		if(iAnimate != -1)
		{
			istretch_x +=3;
			istretch_y +=3;
			if(istretch_x > 150)
			{
				
				bItems_X[iChosen] = iTemp_X;
				bItems_Y[iChosen] = iTemp_Y;
				istretch_x = 32;
				istretch_y = 32;
				iAnimate = -1;
				//if(iChosen < 3)
				//{
					for(int j = 0; j < 3; j++)
						set_item(j, QUESTION, 0, 8);					
				//}
				iChosen = -1;
				
				
			}
		}
		else
		{
			if(x < dx) x += 20;
			if(x > dx) x -= 20;
			if(y < dy) y += 20;
			if(y > dy) y -= 20;		
		}
		
	}
	if(abs(ticks - animate_timer) > 10)
	{		
		update_animate(GAME.fMX, GAME.fMY);
		animate_timer = ticks;
	}
	debug("PENALTY update() DONE!\n", 3);
	
	
}

void PENALTY::input(int X, int Y)
{	
	if(lock == true) return;
	if(mouse_b & 1)
		choose(X, Y);	
	else
		mlock = false;
	
}

void PENALTY::update_animate(int X, int Y)
{
	bool found = false;
	for(int i = 0; i < MAX_PENALTIES; i++)
	{
		if((X > bItems_X[i] + x && X < bItems_X[i] + 32 + x
			&& Y > bItems_Y[i] + y && Y < bItems_Y[i] + 32 + y) || i == iChosen)
		{
			found = true;
			if(!alock)
			{
				alock = true;
				GAME.audio.play_sfx(13);
				if(i <= 2)
					pPick = QUESTION;
				else
					pPick = pItems[i];
			}
			iFrames_X[i]++;
			if(iFrames_X[i] >= iMax_Frames[i]) iFrames_X[i] = 0;	
		}
		else
			iFrames_X[i] = 0;
		
	}	
	if(!found) 
	{
		alock = false;
		pPick = NO_PENALTY;
	}
}

void PENALTY::draw(BITMAP *bDisplay)
{
	debug("PENALTY draw() called!\n");
	char cMSG[80];	
	draw_sprite(bDisplay, bImage, x, y);
	for(int i = 0; i < MAX_PENALTIES; i++)
	{
		if(iAnimate == i)
			masked_stretch_blit(bItems[i], bDisplay, iFrames_X[i] * 32, 0, 32, 32, bItems_X[i] - istretch_x, bItems_Y[i] - istretch_y, istretch_x * 2, istretch_y * 2);
		else
			masked_blit(bItems[i], bDisplay, iFrames_X[i] * 32, 0, bItems_X[i] + x, bItems_Y[i] + y, 32, 32);
	}

	set_palette((RGB *) GAME.score_palette);
	switch(pPick)
	{
	case NO_PENALTY: strcpy(cMSG, ""); break;
	case TIME_DECREASE: strcpy(cMSG, "Lose one second."); break;
	case TIME_INCREASE: strcpy(cMSG, "Gain one second."); break;
	case TIME_DECREASE_2: strcpy(cMSG, "Lose two seconds."); break;
	case TIME_DECREASE_4: strcpy(cMSG, "Lose four seconds."); break;
	case PERCENT_DECREASE: strcpy(cMSG, "Need one less percent of toggles underwater."); break;
	case PERCENT_INCREASE: strcpy(cMSG, "Need one more percent of toggles underwater."); break;
	case PERCENT_INCREASE_2: strcpy(cMSG, "Need two more percent of toggles underwater."); break;
	case PERCENT_INCREASE_3: strcpy(cMSG, "Need three more percent of toggles underwater."); break;
	case ROW_INCREASE: strcpy(cMSG, "Extra row/column of toggles."); break;
	case ROW_INCREASE_2: strcpy(cMSG, "Two extra rows/columns of toggles."); break;
	case BONUS_PACKAGE: strcpy(cMSG, "3000 POINTS!"); break;
	case QUESTION: strcpy(cMSG, "Random..."); break;			
	case MAXED: strcpy(cMSG, "Maxed out!"); break;			
	default:  break;
	}

	textprintf_centre_ex(bDisplay, GAME.score_font, GAME.configuration->w / 2, 450, -1, -1, "%s", cMSG);
	debug("PENALTY draw() DONE!\n");
}

void PENALTY::pic_slots()
{
	pItems[0] = pic_random();
	pItems[1] = pic_random();
	pItems[2] = pic_random();
	
	//This is a quick hack for the new version
	//NOTE:  it would be more efficient to have these images pre-loaded in an array
	// of bitmaps and just change the pointers accordingly, but it isn't a big enough
	// performance hit for me to chare at the moment.  :x
	// ***************** PERCENT ***************
	if(GAME.percent >= 1.0)
	{
		set_item(3, MAXED, 250, 320, 0, 1);
		pItems[3] = MAXED;
	}
	else
	{
		set_item(3, PERCENT_INCREASE, 250, 320, 0, 8);
		pItems[3] = PERCENT_INCREASE;
	}
	// ***************** TIME ***************
	if(GAME.secs <= 5)
	{
		set_item(4, MAXED, 103, 318, 0, 1);
		pItems[4] = MAXED;
	}
	else
	{
		set_item(4, TIME_DECREASE, 103, 318, 0, 8);
		pItems[4] = TIME_DECREASE;
	}

	// ***************** ROW/COLUMN's ***************
	if(GAME.bBoard->bsize() >= 30)
	{
		set_item(5, MAXED, 19,  173, 0, 1);	
		pItems[5] = MAXED;
	}
	else
	{
		set_item(5, ROW_INCREASE, 19,  173, 0, 8);	
		pItems[5] = ROW_INCREASE;
	}	
}

PENALTIES PENALTY::pic_random()
{
	int pchance = 0, finite_loop = 0;
	PENALTIES pRetval = NO_PENALTY;

	while(finite_loop < 100 && (pRetval == NO_PENALTY || pRetval == MAXED))
	{
		pchance = rand() % 100;
		if(pchance > 90)
			pRetval = TIME_DECREASE;
		else if(pchance <= 90 && pchance > 80)
			pRetval = TIME_DECREASE_2;
		else if(pchance <= 80 && pchance > 70)
			pRetval = PERCENT_INCREASE;
		else if(pchance <= 70 && pchance > 65)
			pRetval = PERCENT_INCREASE_2;
		else if(pchance <= 65 && pchance > 60)
			pRetval = PERCENT_INCREASE_3;
		else if(pchance <= 60 && pchance > 50)
			pRetval = ROW_INCREASE;
		else if(pchance <= 50 && pchance > 45)
			pRetval = ROW_INCREASE_2;
		else if(pchance <= 45 && pchance > 30)
			pRetval = BONUS_PACKAGE;
		else if(pchance <= 30 && pchance > 15)
			pRetval = TIME_INCREASE;
		else
			pRetval = PERCENT_DECREASE;

		if((pRetval == PERCENT_INCREASE && GAME.percent >= 1.0) ||
		   (pRetval == PERCENT_INCREASE_2 && GAME.percent >= 0.99) ||
		   (pRetval == PERCENT_INCREASE_3 && GAME.percent >= 0.98))
			pRetval = NO_PENALTY;

		if((pRetval == TIME_DECREASE && GAME.secs <= 5) || 
		   (pRetval == TIME_DECREASE_2 && GAME.secs <= 6)) 
		   pRetval = NO_PENALTY;

		if((pRetval == ROW_INCREASE && GAME.bBoard->bsize() >= 30) ||
		   (pRetval == ROW_INCREASE_2 && GAME.bBoard->bsize() >= 29))
		   pRetval = NO_PENALTY;
		
		finite_loop++;
	}

	if(pRetval == NO_PENALTY)
		pRetval = TIME_DECREASE;
	

	return pRetval;
}

void PENALTY::unlock()
{
	lock = false;
	alock = false;
	mlock = false;
}

void PENALTY::choose(int X, int Y)
{
	int iSlot = -1;
	for(int i = 0; i < MAX_PENALTIES; i++)
	{
		if(X > bItems_X[i] + x && X < bItems_X[i] + 32 + x
			&& Y > bItems_Y[i] + y && Y < bItems_Y[i] + 32 + y)
			iSlot = i;
		
	}
	if(iSlot != -1 && pItems[iSlot] != MAXED)
	{		
		pTemp = pItems[iSlot];
		pPick = pTemp;
		iAnimate = iSlot;
		iTemp_X = bItems_X[iSlot];
		iTemp_Y = bItems_Y[iSlot];
		iChosen = iSlot;
		bItems_X[iSlot] = GAME.configuration->w / 2 - 16;
		bItems_Y[iSlot] = GAME.configuration->h / 2 - 16;		
		lock = true;		
		GAME.audio.play_sfx(3, 1500);
		
		for(int j = 0; j < 3; j++)
		{
			switch(pItems[j])
			{
				case TIME_INCREASE: set_item(j, TIME_INCREASE, 0, 8); break;
				case TIME_DECREASE: set_item(j, TIME_DECREASE, 0, 8); break;
				case TIME_DECREASE_2: set_item(j, TIME_DECREASE_2, 0, 8); break;
				case TIME_DECREASE_4: set_item(j, TIME_DECREASE_4, 0, 8); break;
				case PERCENT_DECREASE: set_item(j, PERCENT_DECREASE, 0, 8); break;
				case PERCENT_INCREASE: set_item(j, PERCENT_INCREASE, 0, 8); break;
				case PERCENT_INCREASE_2: set_item(j, PERCENT_INCREASE_2, 0, 8); break;
				case PERCENT_INCREASE_3: set_item(j, PERCENT_INCREASE_3, 0, 8); break;
				case ROW_INCREASE: set_item(j, ROW_INCREASE, 0, 8); break;
				case ROW_INCREASE_2: set_item(j, ROW_INCREASE_2, 0, 8); break;
				case BONUS_PACKAGE: set_item(j, BONUS_PACKAGE, 0, 8); break;				
				default:  set_item(j, QUESTION, 0, 8); break;
			}			
		}
	}
	else
	{
		if(mlock != true)
		{
			mlock = true;
			GAME.audio.play_sfx(12);
		}
	}
}

void PENALTY::move(int DX, int DY)
{
	dx = DX;
	dy = DY;
}

void PENALTY::place(int X, int Y)
{
	pic_slots();
	pTemp = NO_PENALTY;
	x = X;
	y = Y;	
}

PENALTIES PENALTY::done()
{
	return pTemp;
}

int PENALTY::position()
{
	return x;
}



void PENALTY::init()
{
	bImage = NULL;
	for(int i = 0 ; i < MAX_PENALTIES; i++)
	{
		pItems[i] = NO_PENALTY;
		iFrames_X[i] = 0;
		iMax_Frames[i] = 0;
		bItems_X[i] = 0;
		bItems_Y[i] = 0;
        bItems[i] = NULL;
	}
	for(int s = 0; s < MAX_STATIC; s++)
		bStatic[s] = NULL;
	x = 0;
	y = 0;
	w = 0;
	h = 0;
	dx = 0;
	dy = 0;
	update_timer = 0;
	animate_timer = 0;
	istretch_x = 32;
	istretch_y = 32;
	iAnimate = -1;

	iTemp_X = 0;
	iTemp_Y = 0;
	iChosen = -1;
	lock = false;
	mlock = false;
	alock = false;
	pPick = NO_PENALTY;
}
