#include "globals.h"
#include "game.h"
#include "progress_bar.h"
#include<math.h>

PROGRESS_BAR::PROGRESS_BAR()
{
	init();
}

PROGRESS_BAR::~PROGRESS_BAR()
{
	destroy();
}

void PROGRESS_BAR::destroy()
{
	if(bImage != NULL) destroy_bitmap(bImage);
}


void PROGRESS_BAR::draw()
{
	debug("PB draw() called!\n");
	int sfgColor_Red = getr(sfgColor);
	int sfgColor_Green = getg(sfgColor);
	int sfgColor_Blue = getb(sfgColor);
	int posx;
	int tsize;
	clear(bImage);
	rectfill(bImage, 0, 0, bImage->w, bImage->h, sbgColor);
	rectfill(bImage, 0, 0, iProgress_X, bImage->h, sfgColor);	
	int i = iProgress_X - 5;
	while(i > 0 && iProgress_X - i <= 255)
	{
		i -= 1;
		rectfill(bImage, i-1, 0, i, bImage->h, makecol(MID(0, sfgColor_Red - (iProgress_X - i), 255), MID(0, sfgColor_Green - (iProgress_X - i), 255), MID(0, sfgColor_Blue - (iProgress_X - i), 255)));
	}
	rectfill(bImage, 0, 0, i-1, bImage->h, BLACK);

	
	
	
	if(!bDone) 
	{
		posx = bImage->w * percent_needed;
		tsize = 3;
		line(bImage, posx, 0, posx, bImage->h, DEEPSKYBLUE);
		//line(bImage, posx + 1, 0, posx + 1, bImage->h, fgColor);

		rectfill(bImage, posx - tsize, 0, posx + tsize, tsize, LIGHTSKYBLUE);
		rectfill(bImage, posx - tsize, bImage->h, posx + tsize, bImage->h - tsize, LIGHTSKYBLUE);
		triangle(bImage,  posx - tsize, tsize, posx, tsize * 2, posx + tsize, tsize, SKYBLUE);
		triangle(bImage,  posx - tsize, bImage->h - tsize, posx, bImage->h - tsize*2, posx + tsize, bImage->h - tsize, LIGHTSKYBLUE);

		if(display_text)
		{
			set_palette((RGB *) GAME.msg_palette);			
			textprintf_centre_ex(bImage, GAME.score_font, bImage->w * 0.5, bImage->h * 0.5 - 10, -1, -1, "%2.1f%% of %2.0f%%", percent * 100.0, percent_needed * 100.0);
		}
	}
	else
	{
		if(display_text)
		{		
			set_palette((RGB *) GAME.score_palette);
			textprintf_centre_ex(bImage, GAME.score_font, bImage->w * 0.5, bImage->h * 0.5 - 10, -1, -1, "%d%%", int(percent * 100));
		}
	}

	debug("PB draw() DONE!\n");
}

void PROGRESS_BAR::update()
{
	debug("PB update() called!\n", 2);
	iProgress_X = w * percent;
	if(bFlashing)
	{
		flash_delay = 30 * (percent_needed - percent - 0.2);
		if(flash_delay < 1) flash_delay = 1;
		if(abs(ticks - flash_timer) > flash_delay)
		{
			if(bFlash == true)
			{
				fColor_Intensity += 0.05;
				if(fColor_Intensity >= 1.0) 
				{
					if(sfx) GAME.audio.play_sfx(4);
					fColor_Intensity = 1.0;
					bFlash = false;
				}
			}
			else
			{
				fColor_Intensity -= 0.05;
				if(fColor_Intensity <= 0.0) 
				{
					fColor_Intensity = 0.0;
					bFlash = true;
				}
			}
			sfgColor = flash(fgColor, WHITE, fColor_Intensity);
			flash_timer = ticks;
		}
	}
	if(!bDone && percent * 100.0 >= percent_needed * 100.0)
	{
		sfgColor = fgColor;
		bDone = true;
		bFlashing = false;
		fColor_Intensity = 1.0;
		sfgColor = flash(fgColor, WHITE, fColor_Intensity);
		sbgColor = flash(bgColor, WHITE, fColor_Intensity);
		flash_timer = ticks + 60;
	}
	if(bDone == true && fColor_Intensity > 0.0 && abs(ticks - flash_timer) > 5)
	{
		fColor_Intensity -= 0.03;
		
		sfgColor = flash(fgColor, WHITE, fColor_Intensity);
		sbgColor = flash(BLACK, WHITE, fColor_Intensity);
		if(fColor_Intensity < 0.0) sbgColor = MASK;
		flash_timer = ticks;
	}
	debug("PB update() DONE!\n", 3);
}

BITMAP *PROGRESS_BAR::bDraw()
{
	return bImage;
}
bool PROGRESS_BAR::finished()
{
	return bDone;
}



void PROGRESS_BAR::setup(int W, int H, bool SFX, bool bDisplay)
{
	w = W;
	h = H;
	sfx = SFX;	
	bImage = create_bitmap_check(w,h);
	display_text = bDisplay;
}

void PROGRESS_BAR::setup(int W, int H, int ifgColor, int ibgColor, float fNeeded, bool SFX)
{
	w = W;
	h = H;
	sfx = SFX;	
	bImage = create_bitmap_check(w,h);	
	fgColor = ifgColor;
	bgColor = ibgColor;
	sfgColor = ifgColor;
	sbgColor = ibgColor;
	percent_needed = fNeeded;
	bDone = false;	
	bFlashing = true;	
}



void PROGRESS_BAR::resetup(int ifgColor, int ibgColor, float fNeeded)
{
	fgColor = ifgColor;
	bgColor = ibgColor;
	sfgColor = ifgColor;
	sbgColor = ibgColor;
	percent_needed = fNeeded;
	bDone = false;	
	bFlashing = true;	
}

void PROGRESS_BAR::color_change(int ifgColor)
{
	fgColor = ifgColor;
	sfgColor = ifgColor;
}


void PROGRESS_BAR::set_bar(float fNeeded)
{	
	percent_needed = fNeeded;
}


void PROGRESS_BAR::set_progress(float fPercent)
{
	percent = fPercent;
	if(percent > 1.0) percent = 1.0;
	if(percent < 0.0) percent = 0.0;
}

int PROGRESS_BAR::flash(int iColor1, int iColor2, float fPercent)
{
	int iCRed = getr(iColor1);
	int iCGreen = getg(iColor1);
	int iCBlue = getb(iColor1);
	if(fPercent < 0.0) fPercent = 0.0;
	if(fPercent > 1.0) fPercent = 1.0;
	int iRed = iCRed + (abs(iCRed - getr(iColor2)) * fPercent);
	int iGreen = iCGreen + (abs(iCGreen - getg(iColor2)) * fPercent);
	int iBlue = iCBlue + (abs(iCBlue - getb(iColor2)) * fPercent);	
	if(flash_delay == -1) return iColor1;
	return makecol(iRed, iGreen, iBlue);
}


void PROGRESS_BAR::init()
{
	bgColor = 0;
	fgColor = 0;
	sbgColor = 0;
	sfgColor = 0;
	iProgress_X = 0;
	percent = 0.0;
	bImage = NULL;
	flash_timer = 0;
	fColor_Intensity = 0.0;
	bFlash = true;
	bFlashing = true;
	bDone = false;
	percent_needed = 0.0;
	flash_delay = 0;
	sfx = false;
	display_text = false;
}
