#include "globals.h"
#include "game.h"
#include "pump.h"
#include "data3.h"

PUMP::PUMP()
{
	init();
}

PUMP::~PUMP()
{}

void PUMP::setup(int X, int Y, int x1, int y1, int x2, int y2, int l)
{
	x = X;
	y = Y;
	rx1 = x1;
	rx2 = x2;
	ry1 = y1;
	ry2 = y2;
	z_length = l;
	
	bImage = (BITMAP *) GAME.dat3[PUMP_PCX].dat;
}

void PUMP::draw(BITMAP *bDisplay)
{
	debug("PUMP draw() called!\n");
	draw_sprite(bDisplay, bImage, x, y);
	for(int i = 0; i < MAX_PDROPS; i++)
		if(pDrops[i] != NULL)
		{
			set_trans_blender(0,0,0, pDrops[i]->iTrans);
			drawing_mode(DRAW_MODE_TRANS, bDisplay, 0,0);
	
			line(bDisplay, pDrops[i]->x, pDrops[i]->y, pDrops[i]->x, pDrops[i]->y + pDrops[i]->length, pDrops[i]->col);
			line(bDisplay, pDrops[i]->x + rand() % 2, pDrops[i]->y, pDrops[i]->x  + rand() % 2, pDrops[i]->y + pDrops[i]->length, pDrops[i]->col);
			drawing_mode(DRAW_MODE_SOLID, bDisplay, 0,0);
	
		}
		debug("PUMP draw() DONE!\n");
}	
void PUMP::update()
{
	debug("PUMP update() called!\n", 2);
	//if(rand() % 100 > 10)
	for(int j = 0; j < 5; j++)
		create_drop();

	for(int i = 0; i < MAX_PDROPS; i++)
		if(pDrops[i] != NULL)
		{
			if(pDrops[i]->length < pDrops[i]->max_length) pDrops[i]->length++;
			else 
			{
				if(rand() % 100 > 90) pDrops[i]->x += rand() % 3 - rand() % 3;
				pDrops[i]->y += pDrops[i]->speed;
			}
			if(pDrops[i]->y >= pDrops[i]->dy)
			{
				dx = pDrops[i]->x;
				dy = pDrops[i]->y + pDrops[i]->length;				
				delete pDrops[i];
				pDrops[i] = NULL;
			}
		}
	debug("PUMP update() DONE!\n", 3);
			
}

int PUMP::drop_at_x()
{
	int iTemp = dx;
	if(dx != 0)	dx = 0;
	return iTemp;
}

int PUMP::drop_at_y()
{
	int iTemp = dy;
	if(dy != 0)	dy = 0;
	return iTemp;
}


void PUMP::create_drop()
{
	int i = 0;

	while(i < MAX_PDROPS && pDrops[i] != NULL)
		i++;
	if(i >= MAX_PDROPS) return;
	pDrops[i] = new PUMPING_WATER;
	pDrops[i]->x = rand() % (rx2 - rx1) + rx1;
	pDrops[i]->y = rand() % (ry2 - ry1) + ry1;
	pDrops[i]->length = 1;
	pDrops[i]->dy = pDrops[i]->y + z_length + rand() % 10 - rand() % 10;
	pDrops[i]->max_length = rand() % MAX_DROP_LENGTH - MIN_DROP_LENGTH;
	int t = rand() % 50;
	pDrops[i]->col = makecol(140 + t,140 + t,rand() % 100 + 155);
	pDrops[i]->iTrans = rand() % 100 + 20;
	pDrops[i]->speed = rand() % 5 + 1;
}



void PUMP::destroy()
{	
	for(int i = 0; i < MAX_PDROPS; i++)
		if(pDrops[i] != NULL)
		{ delete pDrops[i]; pDrops[i] = NULL;}
}


void PUMP::init()
{
	bImage = NULL;
	x = 0;
	y = 0;
	rx1 = 0;
	rx2 = 0;
	ry1 = 0;
	ry2 = 0;
	z_length = 0;
	dx = 0;
	dy = 0;

	for(int i = 0; i < MAX_PDROPS; i++)
		pDrops[i] = NULL;
}

